class Pickup_HealthPoint extends UniversalSoldiersPickup;

#exec obj load file=..\Textures\Belt_fx.utx package=Belt_fx

#exec mesh import mesh=HealthPoint anivfile=Models\HealthPoint_a.3d datafile=Models\HealthPoint_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=HealthPoint x=0 y=0 z=0
#exec mesh sequence mesh=HealthPoint seq=All startframe=0 numframes=1

#exec meshmap new meshmap=HealthPoint mesh=HealthPoint
#exec meshmap scale meshmap=HealthPoint x=0.12500 y=0.12500 z=0.25000

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local US_PRI IPRI;

		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			if ( PlayerPawn(Other).Health < US_PRI(PlayerPawn(Other).PlayerReplicationInfo).BaseHealth )
				{
				PlayerPawn(Other).Health += 25;
				if ( PlayerPawn(Other).Health > US_PRI(PlayerPawn(Other).PlayerReplicationInfo).BaseHealth )
					{
					PlayerPawn(Other).Health = US_PRI(PlayerPawn(Other).PlayerReplicationInfo).BaseHealth;
					}
				PlayPickupMessage(PlayerPawn(Other));
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();	
				}
			}
	

	}
}


defaultproperties
{
LifeTime=45
DrawType=DT_Mesh
Mesh=Mesh'HealthPoint'
CollisionRadius=32.00000
CollisionHeight=32.00000
MultiSkins(0)=Texture'Belt_fx.ShieldBelt.BlueShield'
PickupMessage="You picked up 25 health points"
ItemName="HealthPoint"
RespawnTime=0.000000
PickupViewMesh=Mesh'HealthPoint'
PickupSound=Sound'UnrealShare.Generic.RespawnSound'
ScaleGlow=2.000000
bCollideWhenPlacing=True
bRotatingPickup=True
RotationRate=(Roll=12500)
RotationRate=(Pitch=12250)
RotationRate=(Yaw=12000)
}
